import mongoose from 'mongoose';

const dailyCheckInSchema = new mongoose.Schema({
  userId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'User',
    required: true,
    unique: true
  },
  isDailyCheckIn: {
    type: Boolean,
    default: false
  },
  lastCheckIn: {
    type: Date,
    default: null
  },
  checkInStreak: {
    type: Number,
    default: 0
  },
  totalTokensEarned: {
    type: Number,
    default: 0
  }
}, { timestamps: true });


dailyCheckInSchema.methods.canCheckIn = function () {
  // If no check-in has been done yet, the user can check in (return true).
  if (!this.lastCheckIn) {
    return true;
  }

  // Get the current date and the last check-in time
  const now = new Date();
  const lastCheckInTime = new Date(this.lastCheckIn);

  // Calculate the time difference in hours
  const hoursDifference = (now - lastCheckInTime) / (1000 * 60 * 60); // Convert milliseconds to hours

  // Return true if it's been 24 hours or more since the last check-in, otherwise false
  return hoursDifference >= 24;
};

const DailyCheckIn = mongoose.model('DailyCheckIn', dailyCheckInSchema);

export { DailyCheckIn } 
