import error from "#middlewares/error";

import userRoute from "#routes/user.routes";

import authRoute from "#routes/auth.routes";

import userWalletRoute from "#routes/userwallet.routes";

import userReferralSystemRoute from "#routes/referral.routes";

import TransactionHistoryRoutes from "#routes/transactionhistory.routes";

import DailyCheckInRoutes from "#routes/dailycheckin.routes";


import taskRoute from "#routes/task.routes";

const routes = (app,bot) => {
  
  const requiredChatId = '-1002230846494';

  app.use(error);
  app.use("/api", userRoute);
  app.use("/api", authRoute);
  app.use("/api", userWalletRoute);
  app.use("/api", userReferralSystemRoute);
  app.use("/api", TransactionHistoryRoutes);
  app.use("/api", DailyCheckInRoutes);


  // For admin use on;y 
  app.use("/api", taskRoute);

  app.get('/api/check-membership/:id', async (req, res) => {
    // https://api.telegram.org/bot7232837063:AAERB7SbhDpW64SdqWVVBhxX2e3hr9oCUUM/getUpdates getGropId
    // http://localhost:5000/api/check-membership/6183559750 getMembership
    const userId = req.params.id;
    try {
        // Use bot to check if the user is a member of the group/channel
        const member = await bot.telegram.getChatMember(requiredChatId, userId);

        if (member.status === 'member' || member.status === 'administrator' || member.status === 'creator') {
            res.json({ isMember: true });
        } else {
            res.json({ isMember: false });
        }
    } catch (error) {
        console.error('Error checking membership:', error);
        res.json({ isMember: false, error: 'Error checking membership' });
    }
});

app.get('/api/check-channel/:id', async (req, res) => {
    const userId = req.params.id;
    const requiredChatId = '@botgamechanne'; // Channel ka chat ID yahan set karain

    try {
        // Check if the user is a member of the channel
        const member = await bot.telegram.getChatMember(requiredChatId, userId);

        // Check if the user is a member, administrator, or creator of the channel
        if (member.status === 'member' || member.status === 'administrator' || member.status === 'creator') {
            res.json({ isMember: true });
        } else {
            res.json({ isMember: false });
        }
    } catch (error) {
        console.error('Error checking membership:', error);
        res.json({ isMember: false, error: 'Error checking membership' });
    }
});

























};
export default routes;
